unit SO_unit;

interface

uses Classes, HW, sysutils, Forms, dialogs,  stdctrls, graphics;


const
     num_estados = 9; // Nmero de filas de estados para BCP's
     num_estados_buffer = 3; // Nmero de filas de estados para buffers
     tam_buffer = tam_pagina; // Nmero mximo de buffers na memria
     delay_blink = 4;  { define um tempo para que o shape referente ao processo do SO
                         fique aceso quando em viso do sistema operacional  }




type


    pointer_BCP = ^TBCP;

    // Tipo BCP
    TBCP = record
         Job : integer; // Identificador do processo
         Tab_Pag : integer; // Endereo da Tabela de Pginas
         ACC : TACC; // Acumulador
         PC : TContador_Programa;
         Timer: TTIMER;  // Armazena o tempo previsto para a execucao do programa
         TS : TTime_Slice;
         FP : TFalta_Pagina;  // Numero da pagina em falta
         RI : TRegistrador_Instrucao; // Registro da instrucao em execucao

         End_Cod : integer; // Endereo do programa no disco (cdigo)
         PCod:integer;       // Apontador corrente da area de codigo (Endereo relativo)
         Tam_prog : integer; // Tamanho do prog. no disco
         End_Dados : integer; // Endereo da rea de dados no disco
         PDados : integer; // Apontador corrente p/ area dados no disco
         End_Impr : integer; // Endereo da rea de impresso no disco
         PImpr : integer; // Apontador corrente da area impresso no disco
         CCI : char;    // Cdigo de condio de interrupo para falta de pginas
                        // de dados. 'R' para leitura e 'W' para escrita

         CKFim : TClock; // Armazena o valor do clock quando o job  terminado
         Int:smallint; // Indica se ouve e qual foi a ltima interrupo envolvendo o job
         FilaAtual:smallint; // Indica qual a fila (Estado) em que se encontra o processo
    end;

    pointer_Buffer = ^TBuffer;
    pointer_Pagina = ^TPagina;

    TBuffer = record
         Pagina:TPagina;
         Tipo:byte;
         JobId:integer;
    end;
    { Tabela de cdigos para os tipos de pginas armazenadas num buffer:

            Valor       |      Tipo
              0         |      Primeira pgina de Cdigo
              1         |      Pgina de Cdigo qualquer
              10        |      Primeira pgina de Dados
              11        |      Pgina de Dados qualquer
              20        |      Primeira pgina de Impressao
              21        |      Pgina de Impressao qualquer
              30        |      ltima pgina do Job

      Estes cdigos sao utilizados para identificar o tipo de uma pgina para
      o processo de impressao}



var  // Variaveis globais do sistema

   tam_memoria:byte; // Nmero pginas da memria

   default_TS:byte;  //  Define o Time Slice padro
   min_TS:byte;      // Define o Time Slice mnimo

   TempoLeitura:byte;  //  Tempo gasto para transferir uma pagina do dispositivo de entrada para o buffer
   TempoDisco:byte;  //  Tempo gasto para efetuar um acesso ao disco
   TempoImpressora:byte; // Tempo gasto para transferir uma pgina do buffer para o dispositivo de sada

   v_inter : Tinterrupcao;     // Vetor Interrupcao
   RC : TRegistrador_Comandos;
   TP : TTP;           // Informacoes pginas
   PC : TContador_Programa;
   PagAtual:byte; // Indica a pgina de cdigo atual para que esta possa ser exibida na interface
   // RI : TRegistrador_Instrucao;
   ACC : TACC;
   //FP : TFalta_Pagina;
   TIMER : TTIMER;   { Tempo mximo de execuo de um processo
                      (usado para garantir que o mesmo, se entrar em um loop infinito, seja terminado)}
   TS : TTime_Slice;
   CK : TClock;
   TC : TTempo_Canal;

   Entrada: TEntrada;
   Saida : Tsaida;

   Memoria : TMemoria;
   Disco : TDisco;

   // Vetor de filas de estados para BCP's
   Estado : array[0..num_estados-1] of TList;
      { Esquema de filas de estado para BCP's

               0 - Fila dos BCP's disponveis
               1 - Programa em processo de entrada (Spool In)
               2 - Programas residentes em disco
               3 - Programas prontos para a execuo
               4 - Programa sendo executado
               5 - Programas suspensos aguardando operaes de ES
               6 - Programas suspensos por falta de pginas
               7 - Programas acabados
               8 - Programa em estado de sada
       }


   // Vetor de filas de estados para buffers
   EstadoBuffer : array[0..num_estados_buffer-1] of TList;
      { Esquema de filas de estado para buffers
               0 - Buffers livres
               1 - Buffers aguardando SPool In
               2 - Buffers aguardando SPool Out
       }

   // Varivel de estado da operao de SpoolIn
   EstadoSpoolIn : integer;
   {
     Valores da variavel EstadoSpoolIn:
               1 - Job
               2 - Prog
               3 - Dados ou Fim
               4 - Fim
   }

   // Armazena posicao na memria da ltima pgina livre encontrada
   lastpos:integer;

   // Esta varivel  True se o arquivo de entrada estiver livre
   EntradaLivre:boolean;

   // True se o SO estiver em execuo
   Executando:boolean;

   // True se a execuo do S.O. estiver em pausa
   Pausa:boolean;

   // Indica quando deve ser mostrada a janela de finalizao de processos na pausa
   ShowKill:boolean;

   // Indica o processo que ser sacrificado
   ProcessoMorto:pointer_BCP;


   // Indica quando devem ser exibidas os dilogos das interrupes fatais
   ShowMessages:boolean;


   // Indica qual a interface est sendo visualizada
   VisaoSistOp:boolean;

procedure Inicializa;
procedure Finaliza;
procedure Principal;
procedure Processos_Simples;


// BCP
procedure Zera_BCP (PBCP : pointer_BCP);
procedure Troca_Fila_BCP( Origem , Destino : smallint);
function  Fila_Vazia_BCP(f:smallint):boolean;


// Buffer
procedure Zera_Buffer(PBuffer : pointer_Buffer);
procedure Troca_Fila_Buffer( Origem , Destino : integer);
procedure Libera_Buffer(fila:integer);
function  Fila_Vazia_Buffer(f:integer):boolean;
function  Num_buffer_livres:integer;



// Processos Simples
procedure Leitura;
procedure SpoolIn;
procedure Loader;
procedure Paginacao;
procedure ES_Usuario;
procedure SpoolOut;
procedure Impressao;



// Auxiliares 1
procedure Escala_Programa;
procedure Executa_Programa;
procedure Inc_PC;
procedure Busca_Instrucao;
procedure Executa_Instrucao;
procedure Atualiza_CK;
procedure Testa_Tempo_Periferico;
procedure Simula_Perifericos;
procedure Salva_Estado_Execucao;
procedure Espera_Interrupcao;
procedure Trata_Interrupcao;
procedure Delay(delay_msec:word);
procedure Wait;

// Auxiliares 2
function  encontra_espaco_livre_disco(tamanho:integer):integer;
function  encontra_pagina_livre_memoria:integer;
function  TipoPagina(PPagina: pointer_Pagina):byte;
function  Troca:integer;
function  Interrupcao:smallint;
procedure CopiaPagina(Origem,Destino:pointer_Pagina);
procedure InicializaBitmaps;
procedure InicializaTabelaPaginas(pos:integer);
procedure Erro(mensagem:String);
procedure ImprimePaginaCodigo (PPagina:pointer_Pagina);
procedure ImprimePaginaComum (PPagina:pointer_Pagina);
procedure Libera_Paginas_Job(TabPag:integer);
procedure ZeraPagina(PPagina:pointer_Pagina);




implementation

uses MainUnit, Kill;



procedure Principal;
begin
   Inicializa;
   repeat
       Processos_Simples;
       if not Fila_Vazia_BCP(3) then begin
            Escala_Programa;
            Executa_Programa;
            Delay(FMain.Updown_Delay.Position);
       end
       else begin
          Espera_Interrupcao;
          Delay(FMain.Updown_Delay.Position);
       end;
       Trata_Interrupcao;

       if ShowKill then FKill.Execute;


       if not Executando then begin
          Finaliza;
          Exit;
       end;
   until False;
end;




procedure Processos_Simples;
begin
     Leitura;
     SpoolIn;
     SpoolOut;
     Impressao;
     Loader;
     Paginacao;
     ES_Usuario;
end;




procedure Inicializa;
var i:integer;
    PBCP: pointer_BCP;
    PBuffer: pointer_Buffer;
begin
     EstadoSpoolIn := 1;

     // Aloca memria para as listas de BCP's
     for i:=0 to num_estados-1 do
         Estado[i] := TList.Create;

     // Aloca memria para as listas de buffers
     for i:=0 to num_estados_buffer-1 do
         EstadoBuffer[i] := Tlist.Create;


     // Cria fila de BCP's livres
     for i:=1 to tam_memoria div 2 do
         begin
              new (PBCP);
              zera_BCP (PBCP);
              Estado[0].Add (PBCP);
         end;

     // Inicia o vetor de interrupes
     for i:=0 to num_interrupcoes-1 do
        FMain.VInter[i]:=False;

      // Cria fila de buffers livres
     for i:=1 to num_buffers do
         begin
              new (PBuffer);
              Zera_Buffer (PBuffer);
              EstadoBuffer[0].Add (PBuffer);
         end;

     // Marca todas as paginas de memoria e disco como livres
     InicializaBitmaps;

     // convenciona primeira pgina livre na memria
     lastpos := 0;

     // Inicializa a pgina atual com um valor inexistente na memria
     PagAtual:=255;

     // Os arquivos de entrada e sada so iniciados como livres
     EntradaLivre := true;


end;




procedure Finaliza;
var i:byte;
begin

   // Desaloca filas de estados de BCP's
   for i:=0 to num_estados-1 do  begin
       while Estado[i].Count>0 do begin
          Dispose(Estado[i].Items[0]);
          Estado[i].Delete(0);
       end;
       Estado[i].Destroy;
   end;

   // Desaloca filas de estados de Buffers
   for i:=0 to num_estados_buffer-1 do  begin
       while EstadoBuffer[i].Count>0 do  begin
           Dispose(EstadoBuffer[i].Items[0]);
           EstadoBuffer[i].Delete(0);
       end;
       EstadoBuffer[i].Destroy;
   end;

   // Limpa os exibidores de estado
   for i:=0 to 7 do (FMain.EstadoPainel.Controls[i] as TMemo).Clear;

   if not EntradaLivre then CloseFile(Entrada);

   // Marca todas as paginas de memoria e disco como livres
   InicializaBitmaps;
   FMain.ClearGrid(FMain.TabPagGrid);
   FMain.ClearGrid(FMain.PagCodAtual);
   FMain.LimpaInfoJob;
   FMain.OpenJob.Files.Clear;
   FMain.LB_TPEnd.Caption:='-';
   FMain.LB_CodEnd.Caption:='-';
end;




procedure ZeraPagina(PPagina:pointer_Pagina);
var i:byte;
begin
   for i:=0 to tam_pagina-1 do begin
      PPagina^[i].c1:=0;
      PPagina^[i].c2:=0;
      PPagina^[i].c3:=0;
   end;
end;



procedure Zera_BCP (PBCP : pointer_BCP);
begin
     with PBCP^ do  begin
        JOB := -1;
        Tab_Pag := -1;
        Acc := 0;
        PC.Pag := -1;  PC.Desl := -1;
        TIMER := -1;
        TS := 0;
        FP := -1;
        RI.CodOp := -1; RI.Pag := -1; RI.Desl := -1;
        End_Cod := -1;
        Tam_prog := 0;
        End_Dados := -1;
        pdados := -1;
        End_Impr := -1;
        pimpr := -1;
        CCI := '*';
        Int:=-1;
        CKFim:=-1;
        FilaAtual:=-1;
    end;
end;




procedure Troca_Fila_BCP( Origem , Destino : smallint);
begin
     if Origem <> 0 then (FMain.EstadoPainel.Controls[Origem-1] as TMemo).Lines.Delete(0);
     if Destino <> 0 then (FMain.EstadoPainel.Controls[Destino-1] as TMemo).Lines.Add(IntToStr(pointer_BCP(Estado[Origem].Items[0])^.Job));

     pointer_BCP(Estado[Origem].Items[0])^.FilaAtual:=Destino;
     Estado[Destino].Add(Estado[Origem].Items[0]);
     Estado[Origem].Delete(0);
end;



procedure Zera_Buffer(PBuffer : pointer_Buffer);
var i:byte;
begin
     for i:=0 to tam_buffer-1 do
         begin
             PBuffer.Pagina[i].c1:=0;
             PBuffer.Pagina[i].c2:=0;
             PBuffer.Pagina[i].c3:=0;
         end;
     PBuffer.Tipo := 100; // Tipo invalido
end;




procedure Troca_Fila_Buffer( Origem , Destino : integer);
begin
     EstadoBuffer[Destino].Add(EstadoBuffer[Origem].Items[0]);
     EstadoBuffer[Origem].Delete(0);
end;



procedure Libera_Buffer(fila:integer);
// Remove o primeiro Buffer da fila "fila"
begin
    Zera_Buffer(EstadoBuffer[fila].Items[0]);
    Troca_Fila_Buffer(fila,0);
end;




function  Fila_Vazia_Buffer(f:integer):boolean;
begin
    result:=EstadoBuffer[f].Count = 0;
end;



function Fila_Vazia_BCP(f:smallint):boolean;
begin
    result:=Estado[f].Count = 0;
end;


function Num_buffer_livres:integer;
// Retorna nmero de buffers presentes na lista de livres
begin
     result := EstadoBuffer[0].Count;
end;






// **********************************************************************
// **************   P R O C E S S O S    S I M P L E S    ***************
// **********************************************************************


procedure Leitura;
var PBuffer: pointer_Buffer;
begin
     // Se o arquivo de entrada est livre e ainda h jobs a serem carregados
     if (EntradaLivre) and (FMain.openjob.Files.Count>0) then begin
        // Associa a Entrada ao novo job
        assignfile(Entrada, FMain.OpenJob.files[0]);
        reset(Entrada);
        // Ocupa varivel de entrada
        EntradaLivre := false;
        // Remove o nome do job do topo da lista de arquivos selecionados pelo usurio
        FMain.OpenJob.files.Delete(0);
     end;


     if (not EntradaLivre) and (not RC.Leitora) and (Num_buffer_livres>1)  and (not eof(Entrada)) then  begin

        RC.Leitora := True;
        TC.Leitora := CK + TempoLeitura;

        // Encontra um buffer livre
        Pbuffer := EstadoBuffer[0].Items[0];

        // Preenche seu contedo com a pgina de entrada
        read(Entrada, Pbuffer^.Pagina);

        // Retira o buffer da fila de livres e o insere na fila de SpoolIn
        Troca_Fila_Buffer (0, 1);

        // Se todo o Job foi lido, libera a varivel de entrada
        if eof(Entrada) then begin
              closefile(Entrada);
              EntradaLivre := true;
        end;


     end;
end;






procedure SpoolIn;
var
    pos: integer; { Indica posicao no disco da primeira pgina do bloco
                   livre encontrado para o novo job }
    PBuffer : pointer_Buffer;
    PBCP : pointer_BCP;
    i:byte;
    TamanhoTotal, TamanhoCodigo, TamanhoDados , TamanhoImpressao : integer; // Indicam o n de paginas para cada area
begin
   if (not RC.Disco) and (not Fila_Vazia_Buffer(1)) then  begin


        { PPagina aponta para a primeira pagina da fila da SpoolIn
          que sera carregada no disco ou descartada}
       PBuffer:=EstadoBuffer[1].Items[0];

       case EstadoSpoolIn of
           1: begin  // Leitura da primeira pagina do JOB
                if (not Fila_Vazia_BCP(0)) then  begin
                     { Esquema da primeira pagina do JOB :

                                      c1  |       c2          |         c3        | Palavra
                          tipo da pagina  |  tipo da pagina   |  tipo da pagina   |    0
                    identificador do JOB  |       -           |         -         |    1
                                   timer  |       -           |         -         |    2
                 n. de paginas de codigo  |       -           |         -         |    3
                  n. de paginas de dados  |       -           |         -         |    4
              n. de paginas de impressao  |       -           |         -         |    5
                                      -   |       -           |         -         |    6
                                      -   |       -           |         -         |    7
                      }

                     TamanhoCodigo:=PBuffer^.Pagina[3].c1;
                     TamanhoDados:=PBuffer^.Pagina[4].c1;
                     TamanhoImpressao:=PBuffer^.Pagina[5].c1;
                     TamanhoTotal:=TamanhoCodigo + TamanhoDados + TamanhoImpressao;
                     { Encontra um bloco livre para o novo JOB,
                       com algoritmo FIRST FIT }
                     pos := encontra_espaco_livre_disco(TamanhoTotal);

                     if pos>=0 then begin
                        // Marca como ocupado o espao encontrado no disco, reservando-o para o novo job
                        for i:=pos + TamanhoTotal downto pos do  Disco.bitmap[i]:=True;

                        Troca_Fila_BCP(0,1);
                        PBCP:=Estado[1].Items[0];

                        // Inicializa o BCP do novo JOB
                        with PBCP^ do begin
                           Job:= PBuffer^.Pagina[1].c1;
                           Timer:= PBuffer^.Pagina[2].c1;
                           Tam_prog:=TamanhoTotal;
                           End_Cod:=pos;
                           End_Dados:=pos + TamanhoCodigo;
                           End_Impr:=End_Dados + TamanhoDados;

                           PCod:=0;    // Ponteiro relativo para a area de dados no disco
                           PDados:=0;  // Ponteiro relativopara a area de dados no disco
                           PImpr:=0;   // Ponteiro relativo para a area de impressao no disco
                        end;

                        Libera_Buffer(1);
                        EstadoSpoolIn:= 2;
                     end
                     else if ShowMessages then
                           ShowMessage('O disco encontra-se momentneamente sem espao'); 
                end;
              end;

           2:begin
               // Descarta a segunda pagina do JOB que eh de inicio de pagina de codigo
                 Libera_Buffer(1);
                 EstadoSpoolIn:= 3;
             end;

           3:begin
                 // Retorna o BCP do JOB que esta atualmente em SpoolIn
                 PBCP:= Estado[1].Items[0];

                 case TipoPagina(@PBuffer^.Pagina) of
                     4: begin     // Encontrada uma pagina de codigo

                        // Simula a utilizao do disco
                        RC.Disco:=True;
                        TC.Disco:= CK + TempoDisco;


                        // Descarrega a pagina no disco
                        CopiaPagina(@PBuffer^.Pagina ,@Disco.Items[PBCP^.End_Cod+PBCP^.PCod]);


                        // Atualiza o apontador corrente da area de codigo no disco
                        Inc(PBCP^.PCod);

                     end;

                     2:begin // Encontrada uma pagina da controle de inicio de dados
                            EstadoSpoolIn:=4;
                     end;

                     3: begin  // Encontrada uma pagina da controle de fim
                            Troca_Fila_BCP(1,2);
                            PBCP^.PCod:=0;
                            EstadoSpoolIn:=1;
                     end;
                 end;
                 Libera_Buffer(1);
             end;

           4:begin
                // Retorna o BCP do JOB que esta atualmente em SpoolIn
                 PBCP:= Estado[1].Items[0];

                 if  TipoPagina(@PBuffer^.Pagina)=4 then begin // Encontrada uma pagina de dados

                     // simula a utilizao do disco
                     RC.Disco:=True;
                     TC.Disco:= CK + TempoDisco;

                     // Descarrega a pagina no disco
                     CopiaPagina(@PBuffer^.Pagina ,@Disco.Items[PBCP^.End_Dados+PBCP^.PDados]);

                     // Atualiza o apontador corrente da area de codigo no disco
                     Inc(PBCP^.PDados);

                 end
                 else begin // Encontrada a pagina de fim do JOB
                     Troca_Fila_BCP(1,2);
                     PBCP^.PDados:=0;
                     EstadoSpoolIn:=1;
                 end;

                 Libera_Buffer(1);
           end;
       end;
   end;
end;




procedure Loader;
var
   poslivre:integer;
   PBCP:pointer_BCP;

begin

     if (not RC.Disco) and (not Fila_Vazia_BCP (2)) then begin

         // Referencia o primeiro BCP dos residentes em disco
         PBCP := Estado[2].Items[0];

         // Procura espaco livre para tabela de pginas do Job
         poslivre := encontra_pagina_livre_memoria;
         if poslivre = -1 then begin
              // 'Mata' o processo por falta de espao na memria
              FMain.VInter[5]:=True;
              ProcessoMorto:=PBCP;
 //             Trata_Interrupcao;      // tirou funcionou
              Exit;
         end;

         InicializaTabelaPaginas(poslivre);
         FMain.BitMem [poslivre] := 1;

         // guarda endereco tabela de pginas no BCP do job
         PBCP^.Tab_Pag := poslivre;

         // Procura espaco para primeira pgina de CDIGO do job
         poslivre := encontra_pagina_livre_memoria;
         if poslivre = -1 then begin
              // 'Mata' o processo por falta de espao na memria
              FMain.VInter[5]:=True;
              ProcessoMorto:=PBCP;
              Trata_Interrupcao;
              Exit;
         end;

         // simula a utilizao do disco
         RC.Disco := true;
         TC.Disco := CK + TempoDisco;


         // Copia a primeira pgina de cdigo do disco para a memria
         FMain.BitMem [poslivre] := 2;
         CopiaPagina(@Disco.Items[PBCP^.End_Cod], @memoria.Items[poslivre]);

         // Indica pgina de cdigo presente na memria
         Memoria.Items[PBCP^.Tab_Pag][0].c1:= 1;

         // Armazena endereo real da primeira pgina de cdigo
         Memoria.Items[PBCP^.Tab_Pag][0].c2:= poslivre;


         // Atualiza contador da pagina com o clock do sistema
         Memoria.Contador[poslivre]:= CK;


         PBCP^.TS := default_TS;

         { O PC armazenado no BCP aponta para a primeira instruo do job, cuja
           localizao  dada pelo endereo virtual da 1a pgina de cdigo (na tabela
           de pgina) e pela primeira palavra}
         PBCP^.PC.Pag := 0;
         PBCP^.PC.Desl := 0;

         Troca_Fila_BCP (2, 3);
     end;
end;



procedure Paginacao;
var
   poslivre: integer;
   PBCP: pointer_BCP;
   end_origem: integer;
begin
   if (not RC.Disco) and (not Fila_Vazia_BCP (6)) then begin

        // PBCP aponta para o primeiro job na fila esperando paginacao
        PBCP:= Estado[6].Items[0];

        // Procura espaco livre a nova pgina de cdigo
      	poslivre := encontra_pagina_livre_memoria;
        if poslivre = -1 then begin
             // 'Mata' o processo por falta de espao na memria
             FMain.VInter[5]:=True;
             ProcessoMorto:=PBCP;
             Trata_Interrupcao;
             Exit;
        end;

        // Define o enderec de origem (disco) da nova pgina a ser carregada
        end_origem:= PBCP^.End_Cod + PBCP^.FP;

        // Atualiza o contador da nova pgina
        Memoria.Contador[poslivre]:= CK;

        CopiaPagina(@Disco.Items[end_origem], @Memoria.Items[poslivre]); // Carrega a pagina na memoria

        Memoria.Items[PBCP^.Tab_Pag][PBCP^.FP].c1:= 1;  // Marca pagina de codigo presente na tabela de paginas
        Memoria.Items[PBCP^.Tab_Pag][PBCP^.FP].c2:= poslivre; // Marca o endereco absoluto desta pagina

        // Indica as modificaes feitas na tabela de pginas
        FMain.TabPagGrid.Cells[0, PBCP^.FP]:='1';
        FMain.TabPagGrid.Cells[1, PBCP^.FP]:=IntToStr(poslivre);

        FMain.BitMem[poslivre]:=2;

        // Simula a utilizao do disco
        RC.Disco := True;
        TC.Disco := CK + TempoDisco;

        Troca_Fila_BCP (6, 3);
  end;
end;





procedure ES_Usuario;
var PBCP:pointer_BCP;
    poslivre, End_Virt, End_Real:integer;
begin

   if (not RC.Disco) and (not Fila_Vazia_BCP (5)) then begin

         // Apontar para o primeiro BCP da fila esperando E/S
         PBCP := Estado[5].Items[0];

         RC.Disco := True;  // Disco Ocupado
         TC.Disco := CK + TempoDisco; // Calcula tempo de trmino da transferencia

         case PBCP^.RI.CodOp of // Le registro de instrucao do Job

              1 :  begin // Instrucao RD : transferencia do disco p/ mem.

                   { "tam_pagina - (PBCP^.End_Dados - PBCP^.End_Cod)" corresponde ao nmero
                       de posices na tabela de pgina reservadas para pginas de dados }
                   if PBCP^.RI.Pag >= tam_pagina - (PBCP^.End_Dados - PBCP^.End_Cod) then begin
                      { 'Mata' o processo pois ele est querendo carregar uma pgina de dados
                         no lugar reservado para pgina de cdigo }
                      FMain.VInter[0]:=True;
                      ProcessoMorto:=PBCP;
                      Trata_Interrupcao;
                      Exit;
                   end;

                   // End_Virt recebe o endereo virtual da pagina de dados obtido do RI
                   End_Virt:=tam_pagina -1 - PBCP^.RI.Pag;

                   if Memoria.Items[PBCP^.Tab_Pag][End_Virt].c1 = 0 then begin
                        { O endereo virtual nao referencia uma pgina de dados preexistente
                          Busca pgina livre na memria }
                        poslivre := encontra_pagina_livre_memoria;
                        if poslivre = -1 then begin
                           // 'Mata' o processo por falta de espao na memria
                           FMain.VInter[5]:=True;
                           ProcessoMorto:=PBCP;
                           Trata_Interrupcao;
                           Exit;
                        end;
                   end
                   else  poslivre:=Memoria.Items[PBCP^.Tab_Pag][End_Virt].c2;

                   // Efetua transferencia para memria
                   CopiaPagina(@Disco.Items[PBCP^.End_Dados+PBCP^.PDados],
                               @memoria.Items[poslivre]);

                   // Atualiza Tabela de pginas
                   Memoria.Items[PBCP^.Tab_Pag][End_Virt].c1:= 2;  // Marca pagina de dados presente na tabela de paginas
                   Memoria.Items[PBCP^.Tab_Pag][End_Virt].c2:= poslivre; // Marca o endereco absoluto desta pagina

                   // Indica as modificaes feitas na tabela de pginas
                   FMain.TabPagGrid.Cells[0, End_Virt]:='2';
                   FMain.TabPagGrid.Cells[1, End_Virt]:=IntToStr(poslivre);

                   FMain.BitMem[poslivre]:=3;

                   // Aponta para prxima pgina de dados no disco (endereco relativo)
                   Inc(PBCP^.PDados);
              end;

              2 : begin // Instrucao PRN : transferencia da memria para o disco
                   End_Real:=memoria.Items[PBCP^.Tab_Pag][tam_pagina-1-PBCP^.RI.Pag].c2;
                   // Efetua transferencia para o disco
                   CopiaPagina(@memoria.Items[End_Real],
                               @Disco.Items[PBCP^.End_Impr+PBCP^.PImpr]);

                   // Aponta para prxima pgina de impressao no disco (endereco relativo)
                   Inc(PBCP^.PImpr);
              end;
         end;
         Troca_Fila_BCP(5, 3); // Move Job para fila dos prontos p/ execucao
   end;
end;





procedure SpoolOut;
var  PBCP:pointer_BCP;
     PBuffer:pointer_Buffer;

label Home;

begin
     // Transfere todos os programas da fila de acabados para a fila de Spool Out
     while not Fila_Vazia_BCP(7) do begin
         PBCP:=Estado[7].Items[0];
         PBCP^.PCod:=0;  // Inicia este ponteiro para varrer  as paginas de codigo, dados e impressao do job no procedimento de Spool Out
         Troca_Fila_BCP(7,8);
     end;

     if (not RC.Disco) and (not Fila_Vazia_Buffer(0)) and (not Fila_Vazia_BCP(8)) then begin

         // PBCP aponta para o primeiro BCP na fila de Spool Out
         PBCP:=Estado[8].Items[0];

         // Aloca buffer livre
         Troca_Fila_Buffer(0,2);

         // PBuffer aponta para o ultimo buffer da fila de Spool Out que acabou de ser alocado
         PBuffer:=EstadoBuffer[2].Items[EstadoBuffer[2].Count-1];


         // Identifica o tipo da pgina e atualiza o campo correspondente no buffer
         if PBCP^.PCod = 0 then begin
             PBuffer^.Tipo := 0; // Primeira pgina de Cdigo
             PBuffer^.JobId := PBCP^.Job;

             // Simula a utilizacao do disco
             RC.Disco := True;
             TC.Disco := CK + TempoDisco;

             // Descarrega pagina do disco para o buffer
             CopiaPagina(@Disco.Items[PBCP^.End_Cod + PBCP^.PCod], @PBuffer^.Pagina);
             Disco.bitmap[PBCP^.End_Cod + PBCP^.PCod]:=False;
             Inc(PBCP^.PCod);

             Exit;
         end;
         if (PBCP^.PCod<PBCP^.End_Dados-PBCP^.End_Cod) then begin
             PBuffer^.Tipo := 1; // Pagina de cdigo qualquer

             // Simula a utilizacao do disco
             RC.Disco := True;
             TC.Disco := CK + TempoDisco;

             // Descarrega pagina do disco para o buffer
             CopiaPagina(@Disco.Items[PBCP^.End_Cod + PBCP^.PCod], @PBuffer^.Pagina);
             Disco.bitmap[PBCP^.End_Cod + PBCP^.PCod]:=False;
             Inc(PBCP^.PCod);

             Exit;
         end;
         if PBCP^.PCod = PBCP^.End_Dados-PBCP^.End_Cod then begin
             PBuffer^.Tipo := 10; // Primeira pgina de Dados

             // Simula a utilizacao do disco
             RC.Disco := True;
             TC.Disco := CK + TempoDisco;

             // Descarrega pagina do disco para o buffer
             CopiaPagina(@Disco.Items[PBCP^.End_Cod + PBCP^.PCod], @PBuffer^.Pagina);
             Disco.bitmap[PBCP^.End_Cod + PBCP^.PCod]:=False;
             Inc(PBCP^.PCod);

             Exit;
         end;
         if (PBCP^.PCod<PBCP^.End_Impr-PBCP^.End_Cod) then begin
             PBuffer^.Tipo := 11; // Pagina de dados qualquer

             // Simula a utilizacao do disco
             RC.Disco := True;
             TC.Disco := CK + TempoDisco;

             // Descarrega pagina do disco para o buffer
             CopiaPagina(@Disco.Items[PBCP^.End_Cod + PBCP^.PCod], @PBuffer^.Pagina);
             Disco.bitmap[PBCP^.End_Cod + PBCP^.PCod]:=False;
             Inc(PBCP^.PCod);

             Exit;
         end;
         if PBCP^.PCod = (PBCP^.End_Impr-PBCP^.End_Cod) then begin // Primeira pgina de Impressao
             if PBCP^.Int<>6 then begin
                // Se for uma interrupo fatal, no imprimir as pginas de impresso
                while PBCP^.PCod< PBCP^.Tam_prog do begin
                    // Libera todas as pginas de Impresso
                    Disco.bitmap[PBCP^.End_Cod + PBCP^.PCod]:=False;
                    Inc(PBCP^.PCod);
                end;
                goto Home;
             end;
             PBuffer^.Tipo := 20;

             // Simula a utilizacao do disco
             RC.Disco := True;
             TC.Disco := CK + TempoDisco;

             // Descarrega pagina do disco para o buffer
             CopiaPagina(@Disco.Items[PBCP^.End_Cod + PBCP^.PCod], @PBuffer^.Pagina);
             Disco.bitmap[PBCP^.End_Cod + PBCP^.PCod]:=False;
             Inc(PBCP^.PCod);

             Exit;
         end;
         if (PBCP^.PCod<PBCP^.Tam_Prog) then begin
             // Pagina de impresso qualquer
             if PBCP^.Int<>6 then begin
                // Se for uma interrupo fatal, no imprimir as pginas de impresso
                while PBCP^.PCod< PBCP^.Tam_prog do begin
                    // Libera todas as pginas de Impresso
                    Disco.bitmap[PBCP^.End_Cod + PBCP^.PCod]:=False;
                    Inc(PBCP^.PCod);
                end;
                goto Home;
             end;
             PBuffer^.Tipo := 21;

             // Simula a utilizacao do disco
             RC.Disco := True;
             TC.Disco := CK + TempoDisco;

             // Descarrega pagina do disco para o buffer
             CopiaPagina(@Disco.Items[PBCP^.End_Cod + PBCP^.PCod], @PBuffer^.Pagina);
             Disco.bitmap[PBCP^.End_Cod + PBCP^.PCod]:=False;
             Inc(PBCP^.PCod);

             Exit;
         end;
         if PBCP^.Pcod = PBCP^.Tam_Prog then begin // ltima pgina do Job

           Home:
             PBuffer^.JobId := PBCP^.Job;
             PBuffer^.Tipo := 30; // Buffer vazio que indica que o job acabou naturalmente

             // Armazena dados sobre a finalizao do JOB
             PBuffer^.Pagina[0].c1:=PBCP^.Int;
             PBuffer^.Pagina[1].c1:=PBCP^.CKFim;
             PBuffer^.Pagina[2].c1:=PBCP^.PC.Pag;
             PBuffer^.Pagina[2].c2:=PBCP^.PC.Desl;
             PBuffer^.Pagina[3]:=TPalavra(PBCP^.RI);
             PBuffer^.Pagina[4].c1:=PBCP^.ACC;
             PBuffer^.Pagina[5].c1:=PBCP^.Timer;

             Zera_BCP(PBCP);
             Troca_Fila_BCP(8,0);
             FMain.LimpaInfoJob;
         end;
     end;
end;




procedure Impressao;
var PBuffer:pointer_Buffer;
begin
     if (not RC.Impressora) and (not Fila_Vazia_Buffer(2)) then begin

     	// Aponta para o primeiro buffer da lista
     	PBuffer:=EstadoBuffer[2].Items[0];

        // Simula a utilizacao da impressora
        RC.Impressora := True;
        TC.Impressora := CK + TempoImpressora;

        case PBuffer^.Tipo of

            0 : begin // Pgina inicial de cdigo
        	    assignFile(Saida, IntToStr(PBuffer^.JobId)+'.txt');
                    rewrite(Saida);

                    writeln (Saida, '*****   Impressao de Job  ******', #13#10);
                    writeln (Saida, '   Job N. '+inttostr(PBuffer^.JobId), #13#10);
                    writeln (Saida, 'Pginas de Cdigo', #13#10);

                    ImprimePaginaCodigo(@PBuffer^.Pagina);
                    writeln(Saida);
                end;

            1 : begin // Pgina qualquer de cdigo
                    ImprimePaginaCodigo(@PBuffer^.Pagina);
                    writeln(Saida);
                end;

            10 : begin // Pgina inicial de dados
                    writeln (Saida, 'Pginas de Dados', #13#10);
                    ImprimePaginaComum(@PBuffer^.Pagina);
                    writeln(Saida);
                 end;

            11 : begin // Pgina qualquer de dados
                    ImprimePaginaComum(@PBuffer^.Pagina);
                    writeln(Saida);
                 end;

            20 : begin // Pgina inicial de impressao
                    writeln (Saida, 'Pginas de Impresso', #13#10);
                    ImprimePaginaComum(@PBuffer^.Pagina);
                    writeln(Saida);
                 end;

            21 : begin // Pgina qualquer de impressao
                    ImprimePaginaComum(@PBuffer^.Pagina);
                    writeln(Saida);
                 end;

            30 : begin // Buffer vazio usado para separar um job do prximo

               	    if PBuffer^.Pagina[0].c1<>6 then
                        // Interrupes fatais
                        writeln(Saida, #13#10, 'Processo finalizado por uma interrupo fatal');

                    // Testa o tipo da interrupo que est armazenada em   PBuffer^.Pagina[0].c1
                    case PBuffer^.Pagina[0].c1 of
                        0:writeln(Saida, #13#10, '    -> Proteo de memria');
                        1:writeln(Saida, #13#10, '    -> Operao invlida');
                        2:writeln(Saida, #13#10, '    -> Overflow');
                        3:writeln(Saida, #13#10, '    -> Interrompido pelo usurio');
                        4:writeln(Saida, #13#10, '    -> Tempo limite esgotado');
                        5:writeln(Saida, #13#10, '    -> Memria insuficiente');
                        6:writeln(Saida, #13#10, '    -> Processo finalizado normalmente');
                    end;

                    writeln(Saida, #13#10, '*** Informaces sobre a finalizao ***', #13#10);
                    writeln(Saida, Format('Clock            %10d',[PBuffer^.Pagina[1].c1]));
                    writeln(Saida, Format('PC                 %3d, %3d',[PBuffer^.Pagina[2].c1, PBuffer^.Pagina[2].c2]));
                    writeln(Saida, Format('RI            %4s  %3d %3d',[Instr[PBuffer^.Pagina[3].c1], PBuffer^.Pagina[3].c2, PBuffer^.Pagina[3].c3]));
                    writeln(Saida, Format('Acumulador        %9d',[PBuffer^.Pagina[4].c1]));
                    writeln(Saida, Format('Timer                %6d',[PBuffer^.Pagina[5].c1]));

                    closefile(Saida);
                 end;
        end; // End do Case

        // Libera o buffer
        Libera_Buffer(2);
     end;
end;




// **********************************************************************
// **************   F U N C O E S    A U X I L I A R E S    *************
// **********************************************************************


function Troca:integer;
{  Algoritmo utilizado:  Pagina Menos Recentemente Utilizada
   Cada pagina de codigo na memoria possui um contador que armazena o valor de CK do ultimo acesso a mesma
   Este procedimento elimina a pagina da memoria que possui o menor contador }
var
    i,j:integer;
    PosTabPag:integer; // Endereco da tabela de pagina contendo pagina de codigo a ser removida
    PosPagCod:integer; // Endereco da pagina codigo a ser removida
    PosPagCodTab:integer; // Posio da pgina de cdigo a ser removida na tabela de pgina
    PPagina:pointer_Pagina;
    count:TClock;

begin
    count:=999999999;
    PosTabPag:=-1;
    PosPagCod:=-1;
    PosPagCodTab:=-1;

    for i:=0 to tam_memoria-1 do
       if FMain.BitMem[i]=1 then begin  // Tabela de pgina encontrada
           PPagina:=@Memoria.Items[i];
           for j:=0 to tam_pagina-1 do
              if PPagina^[j].c1=1 then  // Pgina de cdigo encontrada
                  if Memoria.Contador[PPagina^[j].c2] < count then begin
                      count:=Memoria.Contador[PPagina^[j].c2];
                      PosTabPag:=i;   // Marca a posicao da tabela de pagina
                      PosPagCod:=PPagina^[j].c2;  // Marca o endereco da pagina de codigo na memoria
                      PosPagCodTab:=j;  // Marca a posicao da pagina dentro da tabela de paginas
                  end;

       end;

    result:= PosPagCod;

    if PosPagCod=-1 then begin
        // Ocorre quando no h mais pginas de cdigo para serem retiradas
        result:= PosPagCod;
        Exit;
    end;

    { Marca na tabela de pginas (da pgina de cdigo a ser retirada)
      a pagina de cdigo como ausente }
    Memoria.Items[PosTabPag][PosPagCodTab].c1:=0;
    Memoria.Items[PosTabPag][PosPagCodTab].c2:=-1;

    // Marca esta pgina de cdigo como ausente no bitmap de memria
    FMain.BitMem[PosPagCod]:=0;


end;




function encontra_espaco_livre_disco(tamanho:integer):integer;
{ Esta funcao varre o bitmap associado ao disco em busca de um bloco
  contguo de pginas livres de tamanho 'tamanho'. Se tal bloco for
  encontrado, a posiao da primeira pgina no bitmap  retornada.
  Caso contrrio,  retornado o valor -1.
  Algoritmo Usado: FirstFit
}
var
    pos, i:integer;

begin
     pos := 0;
     repeat
        while (disco.bitmap[pos]) and (pos<tam_disco) do Inc(pos);
        if pos>=tam_disco then begin
            result:=-1;
            Exit;
        end;
        i:=pos;
        while (not disco.bitmap[i]) and (i<tam_disco) and ((i-pos)<tamanho) do Inc(i);
        if (i-pos)=tamanho then begin
            result:=pos;
            exit;
        end;
        pos:=i+1;
     until False;
end;



function encontra_pagina_livre_memoria:integer;
{ Esta funcao varre o bitmap associado  memria em busca de uma pgina
  livre. Se tal pgina for encontrada, a posiao dela no bitmap  retornada.
  Caso contrrio,  retornado o valor -1.
  Algoritmo Usado: NextFit
}
var
    pos:integer;
begin
     // Posicao atual recebe a posicao da ltima pgina encontrada
     pos := lastpos;

     while (pos<tam_memoria) do begin
        if (FMain.BitMem[pos]=0) then begin// Encontrou pgina livre
            result := pos;
            lastpos := pos;
            exit;
        end;
        Inc(pos);
     end;

     pos:=0;

     while (pos<lastpos) do begin
         if (FMain.BitMem[pos]=0) then begin// Encontrou pgina livre
            result := pos;
            lastpos := pos;
            exit;
        end;
        Inc(pos);
     end;

     result:= Troca;
end;



procedure Libera_Paginas_Job(TabPag:integer);
var i:byte;
begin
   for i:=0 to tam_pagina-1 do
      if Memoria.Items[TabPag][i].c1>0 then
           FMain.BitMem[Memoria.Items[TabPag][i].c2]:=0;  // Libera a pgina na memria

   // Libera a tabela de pginas
   FMain.BitMem[TabPag]:=0;

   // Limpa a exibio da tabela de pgina e da pgina atual de cdigo
   FMain.ClearGrid(FMain.TabPagGrid);
   FMain.ClearGrid(FMain.PagCodAtual);
   FMain.LB_TPEnd.Caption:='-';
   FMain.LB_CodEnd.Caption:='-';
end;




procedure Erro(mensagem:String);
begin
   raise Exception.Create(mensagem);
end;



function TipoPagina(PPagina : pointer_Pagina):byte;
   {        Tipo da paginas  | retorno da funcao  |    cabecalho da pagina
                             |                    |       c1      c2     c3
                Inicio JOB   |        0           |      1000   1000    1000
  Pagina inicial de codigo   |        1           |      2000   2000    2000
   Pagina inicial de dados   |        2           |      3000   3000    3000
         Pagina fim de JOB   |        3           |      4000   4000    4000
 Pagina de dados ou codigo   |        4           |    nenhum dos anteriores

 Estes cdigos sao usados para identificacao das pginas iniciais do job no disco.
 Estas pginas somente sao usadas para introduzir as verdadeiras pginas de cdigo
 e dados e nao serao copiadas para a memria.
 Os cdigos acima so gerados no Editor de Jobs.
 }
begin
    result:=4;
    if (PPagina[0].c1 = PPagina[0].c2) and (PPagina[0].c2 = PPagina[0].c3) then
         case PPagina[0].c1  of
              1000 : result:=0;
              2000 : result:=1;
              3000 : result:=2;
              4000 : result:=3;
              else  result:=4;
         end;

end;



procedure CopiaPagina(Origem,Destino:pointer_Pagina);
var
   i:integer;
begin
    for i:=0 to tam_pagina-1 do
         begin
             Destino[i].c1:=Origem[i].c1;
             Destino[i].c2:=Origem[i].c2;
             Destino[i].c3:=Origem[i].c3;
         end;
end;




procedure InicializaBitmaps;
var i:integer;
begin
    for i:=0 to tam_memoria-1 do
         FMain.BitMem[i]:=0;

    for i:=0 to tam_disco-1 do
         Disco.bitmap[i]:=False;

end;




procedure InicializaTabelaPaginas(pos:integer);
var i:integer;

   {  Esquema da tabela de pginas:
            c1            c2                c3
       Presente/Tipo     Endereo Real     No utilizadado


     Coveno de cdigos para pgina referenciadas da tabela de pginas

               c1    |        conveno
                0    |            Pgina ausente
                1    | Pgina de cdigo presente
                2    |  Pgina de dados presente
   }
begin

    for i:=0 to tam_pagina-1 do begin
    	memoria.Items[pos][i].c1 := 0; // Todas as paginas inicialmente ausentes
        memoria.Items[pos][i].c2 := -1; // Inicializa endereos reais de pginas
        memoria.Items[pos][i].c3 := -1; // Campo no utiliza do na tabela de pginas
    end;
end;




procedure ImprimePaginaCodigo (PPagina:pointer_Pagina);
var i:integer;
    instrucao:String;
begin
    for i:= 0 to tam_pagina-1 do begin
        if (PPagina^[i].c1<0) or (PPagina^[i].c1>num_instr-1)
            then instrucao := 'XXX'
            else instrucao := INSTR[PPagina^[i].c1];

            writeln (Saida, format('%6s%4d%4d', [instrucao, PPagina^[i].c2, PPagina^[i].c3]));
    end;
end;




procedure ImprimePaginaComum (PPagina:pointer_Pagina);
var i:integer;
begin
    for i:= 0 to tam_pagina-1 do
        writeln (Saida, format('%10d', [PPagina^[i].c1]));
end;




function Interrupcao:smallint;
// Retorna True se ocorreu alguma interrupo
var i:byte;
begin
   Result:=-1;
   for i:=0 to num_interrupcoes-1 do
      if FMain.VInter[i] then begin
            Result:=i;
            Break;
      end;
end;






procedure Escala_Programa;
// Escalonador com esquema de fila
var PBCP:pointer_BCP;
begin
   // PBCP aponta para o BCP do processo que ser escalado
   PBCP:=Estado[3].Items[0];

   // Passa o processo da fila de prontos para a fila de execuo
   Troca_Fila_BCP(3,4);

   TIMER:= PBCP^.Timer;
   TS:= PBCP^.TS;

   FMain.JobTimer.Caption := inttostr(PBCP^.Timer);
   FMain.JobTS.Caption := inttostr(PBCP^.TS);


   ACC:= PBCP^.ACC;

   PC.Pag := PBCP^.PC.Pag;
   PC.Desl := PBCP^.PC.Desl;

   FMain.ExibePC;
   FMain.ACCLb.Caption:=IntToStr(ACC);


   TP.Tam := PBCP^.End_Dados - PBCP^.End_Cod;
   TP.Ras := PBCP^.End_Impr - PBCP^.End_Dados;
   TP.Pag := PBCP^.Tab_Pag;
   FMain.ExibeTabPag(TP.Pag);
   if memoria.Items[TP.Pag][PC.Pag].c1 =1 then
       FMain.ExibePagAtual(memoria.Items[TP.Pag][PC.Pag].c2);
   FMain.LB_TPEnd.Caption := inttostr(TP.Pag);



   // Exibe informaes principais do job
   FMain.JobId.Caption := inttostr(PBCP^.Job);
   FMain.JobNumPagCod.Caption := inttostr(PBCP^.End_Dados - PBCP^.End_Cod);
   FMain.JobNumPagDados.Caption := inttostr(PBCP^.End_Impr - PBCP^.End_Dados);
end;





procedure Executa_Programa;
begin
    repeat
       Busca_Instrucao;
       if Interrupcao>=0 then Break;

       if FMain.CheckPasso.Down then begin
          Pausa:=True;
          Wait;
       end;

       Executa_Instrucao;
       if Interrupcao>=0 then Break;
       Testa_Tempo_Periferico;

       if Interrupcao>=0 then Break;
       Simula_Perifericos;
       if Interrupcao>=0 then Break;
    until False;
end;





procedure Inc_PC;
begin
   with PC do
     if Desl=tam_pagina-1 then begin
         Inc(Pag);
         Desl:=0;
     end
     else Inc(Desl);
   FMain.ExibePC;
end;






procedure Busca_Instrucao;
var PBCP:pointer_BCP;
    aux:integer;
begin
    PBCP:=Estado[4].Items[0];

    // Verifica se a pgina est presente na memria
    if memoria.Items[TP.Pag][PC.Pag].c1 <> 1 then begin // Pgina de cdigo ausente
         FMain.VInter[12] := True; // Gera interrupo de Falta de Pgina
         PBCP^.FP := PC.Pag; // Endereo virtual da pgina em falta
    end
    else begin // Copia instruo, pgina e deslocamento para RI
        aux := memoria.Items[TP.Pag][PC.Pag].c2;
        // Se a pgina atual de cdigo for modificada, esta deve ser exibida no StringGrid
        if PagAtual<>aux then begin
            PagAtual:=aux;
            FMain.ExibePagAtual(PagAtual);
            // Exibe nmero da pgina de cdigo atual
            FMain.LB_CodEnd.Caption := inttostr(PagAtual);
        end;

        // Atualiza campo CodOp do registrador de intrues
        PBCP^.RI.CodOp := memoria.items[aux][PC.Desl].c1;
        FMain.RIGrid.Cells[0, 0]:= INSTR[PBCP^.RI.CodOp];

        // Atualiza campo Pag do registraodr de intrues
        PBCP^.RI.Pag := memoria.items[aux][PC.Desl].c2;
        FMain.RIGrid.Cells[1, 0]:= IntToStr(PBCP^.RI.Pag);

        // Atualiza campo Desl do registraodr de intrues
        PBCP^.RI.Desl := memoria.items[aux][PC.Desl].c3;
        FMain.RIGrid.Cells[2, 0]:= IntToStr(PBCP^.RI.Desl);

        { Verifica se a instruo  vlida. Seno, gera
                              interrupo correspondente }
        if (PBCP^.RI.CodOp <0) or (PBCP^.RI.CodOp>num_instr) then begin
           FMain.VInter[1] := True;
           ProcessoMorto:=PBCP;
           Exit;
        end;

        Inc_PC;
        // Atualiza contador da pagina com o clock do sistema
        Memoria.Contador[aux]:= CK;
    end;
end;






procedure Executa_Instrucao;
var PBCP:pointer_BCP;
    aux, aux2: integer;


function ProtecaoMemoria:boolean;
begin
   result:=False;
   if (PBCP^.RI.Pag >= PBCP^.End_Impr - PBCP^.End_Dados)
       or  (PBCP^.RI.Desl >= tam_pagina) or (PBCP^.RI.Desl<0) or (PBCP^.RI.Pag<0)  then begin
         // Gera interrupo de Proteo de memria
         FMain.VInter[0]:=True;
         ProcessoMorto:=PBCP;
         result:=true;
   end;
end;


begin
   PBCP:=Estado[4].Items[0];

   case PBCP^.RI.CodOp of


        4:begin // STORE
            if ProtecaoMemoria then Exit;
            aux := memoria.Items[TP.Pag][tam_pagina-1-PBCP^.RI.Pag].c2;
            memoria.items[aux][PBCP^.RI.Desl].c1 := ACC;

            Atualiza_CK; Atualiza_CK;
            Dec(TIMER, 2);
            Dec(TS, 2);
        end;

        3, 5, 6:begin // LD, SUB , ADD

            if ProtecaoMemoria then Exit;
            aux := memoria.Items[TP.Pag][tam_pagina-1-PBCP^.RI.Pag].c2;
            // Valor a ser subtraido
            aux2 := memoria.items[aux][PBCP^.RI.Desl].c1;

            if PBCP^.RI.CodOp = 6 then  ACC := ACC+aux2
            else if PBCP^.RI.CodOp = 3 then ACC := aux2
                 else ACC := ACC-aux2;

            FMain.ACCLb.Caption:=IntToStr(ACC);
            if Abs(ACC)> ACC_OVERFLOW then begin
                 FMain.VInter[2] := True; // Ativa interrupo de Overflow
                 ProcessoMorto:=PBCP;
            end;

            Atualiza_CK; Atualiza_CK;
            Dec(TIMER, 2);
            Dec(TS, 2);
        end;

        7, 8:begin // JUMP , JNG
            if (PBCP^.RI.Pag>=PBCP^.End_Dados - PBCP^.End_Cod) or (PBCP^.RI.Desl >= tam_pagina)
               or (PBCP^.RI.Pag<0) or (PBCP^.RI.Desl<0) then begin
              // Gera interrupo de Proteo de memria
              FMain.VInter[0]:=True;
              ProcessoMorto:=PBCP;
              Exit;
            end;

            if PBCP^.RI.CodOp = 7 then begin
                // atualiza contador de programa com o contedo de RI
                PC.Pag := PBCP^.RI.Pag;
                PC.Desl := PBCP^.RI.Desl;
                FMain.ExibePC;
            end
            else if ACC<0 then begin // jump se ACC<0
	            PC.Pag := PBCP^.RI.Pag;
                    PC.Desl := PBCP^.RI.Desl;
                    FMain.ExibePC;
                 end;

            Atualiza_CK;
            Dec(TIMER);
            Dec(TS);
        end;

        9, 10, 13, 14:begin //   SUI, ADI, LDI, STI   -> adiciona ou subtrai ou carrega indiretamente
            if ProtecaoMemoria then Exit;
            aux := memoria.Items[TP.Pag][tam_pagina-1-PBCP^.RI.Pag].c2;
            // Ponteiro para o valor a ser adicionado
            aux2 := memoria.items[aux][PBCP^.RI.Desl].c1;

            // aux2 contm o ponteiro, que pode varia de 0 at tam_pagina*(ndados+nimpr)

            aux:= aux2 div tam_pagina;  // Pgina
            aux2:= aux2 mod tam_pagina;  // Deslocamento

            if (aux >= PBCP^.End_Impr - PBCP^.End_Dados)
               or (aux2 >= tam_pagina) or (aux2<0) or (aux<0) then begin
              // Gera interrupo de Proteo de memria
              FMain.VInter[0]:=True;
              ProcessoMorto:=PBCP;
              Exit;
            end;


            aux := memoria.Items[TP.Pag][tam_pagina-1-aux].c2;

            if  PBCP^.RI.CodOp=14 then begin    // STI   -> armazena indiretamente
                 memoria.items[aux][aux2].c1:=ACC;
                 Atualiza_CK; Atualiza_CK; Atualiza_CK;
                 Dec(TIMER, 3);
                 Dec(TS, 3);
                 Exit;
            end;

            // Valor a ser adicionado, subtrado ou carregado
            aux2 := memoria.items[aux][aux2].c1;

            if PBCP^.RI.CodOp = 10 then  ACC := ACC+aux2  //ADDI
            else if PBCP^.RI.CodOp = 13 then ACC := aux2  // LDI
                 else ACC := ACC-aux2;                    // SUI

            FMain.ACCLb.Caption:=IntToStr(ACC);

            if Abs(ACC)> ACC_OVERFLOW then begin
                 FMain.VInter[2] := True; // Ativa interrupo de Overflow
                 ProcessoMorto:=PBCP;
            end;

            Atualiza_CK; Atualiza_CK; Atualiza_CK;
            Dec(TIMER, 3);
            Dec(TS, 3);

        end;
        11, 12:begin  // MUL , DIV
            if ProtecaoMemoria then Exit;
            aux := memoria.Items[TP.Pag][tam_pagina-1-PBCP^.RI.Pag].c2;
            // Valor do multiplicador
            aux2 := memoria.items[aux][PBCP^.RI.Desl].c1;

            if PBCP^.RI.CodOp = 11 then  ACC := ACC*aux2
            else  ACC := ACC div aux2;

            FMain.ACCLb.Caption:=IntToStr(ACC);
            if Abs(ACC)> ACC_OVERFLOW then begin
                 FMain.VInter[2] := True; // Ativa interrupo de Overflow
                 ProcessoMorto:=PBCP;
            end;

            Atualiza_CK; Atualiza_CK; Atualiza_CK;
            Dec(TIMER, 3);
            Dec(TS, 3);

        end;
        2:begin  // PRN
            if (PBCP^.RI.Pag >= PBCP^.End_Impr - PBCP^.End_Dados) or (PBCP^.RI.Pag<0) then begin
              // Gera interrupo de Proteo de memria
              FMain.VInter[0]:=True;
              ProcessoMorto:=PBCP;
              Exit;
            end;
            FMain.VInter[7]:=True;  // Gera interrupo de escrita
            Atualiza_CK;
            Dec(TIMER);
            Dec(TS);
        end;

        1:begin  // READ
            if (PBCP^.RI.Pag >= PBCP^.End_Impr - PBCP^.End_Dados) or (PBCP^.RI.Pag<0) then begin
              // Gera interrupo de Proteo de memria
              FMain.VInter[0]:=True;
              ProcessoMorto:=PBCP;
              Exit;
            end;
            FMain.VInter[8]:=True;  // Ativa a interrupo de leitura
            Atualiza_CK;
            Dec(TIMER);
            Dec(TS);
        end;

        0:begin  // HALT
            FMain.VInter[6]:=True; // Ativa a interrupao de parada
            ProcessoMorto:=PBCP;
            Atualiza_CK;
            Dec(TIMER);
            Dec(TS);
        end;

   end;

   Fmain.JobTS.Caption := inttostr(TS);
   Fmain.JobTimer.Caption := inttostr(Timer);
end;




procedure Delay(delay_msec:word);
var Tempo_atual, Tempo_final:integer; // Tempos atual e final em milisegundos
    Hour, Min, Sec, MSec:word;
begin
    // Obtm a hora atual
    if delay_msec>0 then begin
      DecodeTime(Time, Hour, Min, Sec, MSec);
      Tempo_final := MSec + Sec*1000 + Min*60000 + delay_msec;


       while (true) do begin
            DecodeTime(Time, Hour, Min, Sec, MSec);
            Tempo_atual := MSec + Sec*1000 + Min*60000;
            if pausa then wait;
            if Tempo_atual>=Tempo_final
               then exit;
            Application.ProcessMessages;
       end;
    end
    else begin
       if pausa then wait;
       Application.ProcessMessages;
    end;
end;



procedure Atualiza_CK;
// Verifica que o CLock no se encontre prximo a uma condio de overflow
begin
    Inc(CK);
    if CK>2147483640 then begin
         CK:=0;
         Dec(TC.Leitora, 2147483640);
         Dec(TC.Impressora, 2147483640);
         Dec(TC.Disco, 2147483640);
    end;
    FMain.ClockLb.Caption:=IntToStr(CK);
end;



procedure Testa_Tempo_Periferico;
begin
    if TS <=0 then FMain.VInter[13] := True; // Gera interrupo de Time Slice esgotada
    if TIMER<=0 then begin
        FMain.VInter[4] := True; // Gera interrupo  Timer
        ProcessoMorto:=Estado[4].Items[0];
    end;
    Atualiza_CK;

end;



procedure Simula_Perifericos;
begin
  if RC.Leitora and (TC.Leitora<=CK) then FMain.VInter[9]:=True;
  if RC.Impressora and (TC.Impressora<=CK) then FMain.VInter[10]:=True;
  if RC.Disco and (TC.Disco<=CK) then FMain.VInter[11]:=True;
end;




procedure Salva_Estado_Execucao;
var PBCP:pointer_BCP;
begin
   PBCP:=Estado[4].Items[0];
   PBCP^.PC:=PC;
   PBCP^.Timer:=TIMER;
   PBCP^.ACC:=ACC;
   PBCP^.TS:=TS;
end;



procedure Espera_Interrupcao;
var aux:TClock;
begin
  aux:=CK;
  repeat
     Simula_Perifericos;
     Atualiza_CK;
  until (Interrupcao>=0) or ((CK - aux) >= TempoImpressora);
end;





procedure Trata_Interrupcao;
var Int:smallint;
    i:integer;
begin
   Int:=Interrupcao;
   while Int>=0 do begin
      case Int of
         0,1,2,3,4,5,6:begin // Interrupes Fatais
             if ShowMessages then
               case Int of
                   3:MessageDlg('Processo '+ IntToStr(ProcessoMorto^.Job) + ' terminado pelo usurio', mtInformation, [mbOK], 0);
                   5:MessageDlg('Processo '+ IntToStr(ProcessoMorto^.Job) + ' terminado: Falta de memria', mtWarning, [mbOK], 0);
                   0:MessageDlg(Format('Processo %d terminado: Proteo de memria.'+#13#10+'RI ->  %s %d %d', [ProcessoMorto^.Job,
                     Instr[ProcessoMorto^.RI.CodOp], ProcessoMorto^.RI.Pag, ProcessoMorto^.RI.Desl ]), mtWarning, [mbOK], 0);
                   1:MessageDlg('Processo '+ IntToStr(ProcessoMorto^.Job) + ' terminado: Operao Invlida', mtWarning, [mbOK], 0);
                   2:MessageDlg('Processo '+ IntToStr(ProcessoMorto^.Job) + ' terminado: Overflow', mtWarning, [mbOK], 0);
                   4:MessageDlg('Processo '+ IntToStr(ProcessoMorto^.Job) + ' terminado: Tempo limite esgotado', mtWarning, [mbOK], 0);
               end;
             Libera_Paginas_Job(ProcessoMorto^.Tab_Pag);

             // Armazena dados sobre a finalizao do job
             ProcessoMorto^.PC:=PC;
             ProcessoMorto^.Timer:=TIMER;
             ProcessoMorto^.ACC:=ACC;
             ProcessoMorto^.TS:=TS;
             ProcessoMorto^.Int:=Int;
             ProcessoMorto^.CKFim:=CK;

             // Transfere o job para fila de acabados
             i:=Estado[ProcessoMorto^.FilaAtual].IndexOf(ProcessoMorto);
             (FMain.EstadoPainel.Controls[ProcessoMorto^.FilaAtual-1] as TMemo).Lines.Delete(i);
             (FMain.EstadoPainel.Controls[6] as TMemo).Lines.Add(IntToStr(ProcessoMorto^.Job));
             Estado[7].Add(ProcessoMorto);
             Estado[ProcessoMorto^.FilaAtual].Delete(i);


             for i:=0 to num_interrupcoes-1 do FMain.VInter[i]:=false;
         end;

         12:begin  // Falta Pgina
             Salva_Estado_Execucao;
             pointer_BCP(Estado[4].Items[0])^.TS:=default_TS;
             Troca_Fila_BCP(4,6);  //  Transfere o job para fila esperando paginao
         end;

         13:begin  // Time Slice
             Salva_Estado_Execucao;
             pointer_BCP(Estado[4].Items[0])^.TS:=default_TS;
             Troca_Fila_BCP(4,3); // Transfere o job para fila de prontos para execuo
         end;

         7,8:begin  // E/S Usurio
             Salva_Estado_Execucao;
             pointer_BCP(Estado[4].Items[0])^.TS:=default_TS;
             Troca_Fila_BCP(4,5); // Transfere o job para fila de aguardando E/S
         end;

         9,10,11:begin  // Perifricos de HW
             if not Fila_Vazia_BCP(4) then begin
                 Salva_Estado_Execucao;

                 if pointer_BCP(Estado[4].Items[0])^.TS < min_TS then begin
                      { Caso ele j tenha executado mais da metade do seu Time Slice
                       o job  inserido no final da fila de prontos  }
                     pointer_BCP(Estado[4].Items[0])^.TS:=default_TS;
                     Troca_Fila_BCP(4,3);
                 end
                 else begin // Seno transfere o mesmo para o incio da fila de prontos
                     (FMain.EstadoPainel.Controls[3] as TMemo).Lines.Delete(0);
                     (FMain.EstadoPainel.Controls[2] as TMemo).Lines.Insert(0, IntToStr(pointer_BCP(Estado[4].Items[0])^.Job));
                     pointer_BCP(Estado[4].Items[0]).FilaAtual:=3;
                     Estado[3].Insert(0 , Estado[4].Items[0]);
                     Estado[4].Delete(0);
                 end;
             end;
             case Int of
                 9:   // libera a leitora
                      RC.Leitora:=False;

                10:   // libera a impresssora
                      RC.Impressora:=False;

                11:   // libera o disco
                      RC.Disco:=False;
             end;
         end;
      end;

      FMain.VInter[Int]:=False;  // Zera a interrupo que ocorreu
      Int:=Interrupcao;   // Busca a prxima interuupo
   end;


end;


procedure Wait;
begin
     FMain.BPausa.ImageIndex:=19;
     while Pausa do Application.ProcessMessages;
     FMain.BPausa.ImageIndex:=3;
end;


end.

